-- SELECT: Bir veritabanndaki bir veya daha fazla tablo zerinden veri sorgulamak ve getirmek iin kullanlr.

use Filmler -- Filmler veritabann kullan

-- *: tm stunlar, select: nelerin dnecei, from: hangi tablodan
select * from Film

select Id, adi, yapimyili, yonetmenId, gisesi from Film

-- SQL sorgularnda sadece ihtiyacmz olan stunlar getirmekte fayda var.

-- select ile getirilen bir stun ad as veya as kullanmadan geici olarak deitirilebilir (alias). Bu ileme aliasing denir.
-- Stunlara alias tanmlayabildiimiz gibi alias'lar tablolara da tanmlayabiliriz, yani sorguda kullandmz
-- isimlerini geici olarak deitirebiliriz.
-- Eer arada boluk karakteri ile alias tanmlanmak isteniyorsa [] arasna stun ad yazlmaldr.
select Id as [Film ID], adi as [Film Adi], yapimyili [Yapim Yili], yonetmenId YonetmenID, gisesi [Gisesi] from Film

-- SQL'de metinsel ifadeler tek trnakla ifade edilir. Burada adi ile soyadi stunlarn arada boluk ile 
-- birletiriyoruz (concatenation), yonetmenadisoyadi isimli bir stuna alias vererek dogumtarihi ile birlikte ekiyoruz.
select adi + ' ' + soyadi as yonetmenadisoyadi, dogumtarihi from Yonetmen

-- select ile ekilen veriler bir veya birden ok stun zerinden order by kullanlarak sralanabilir. 
-- order by ile asc, ascending yani artan veya desc, descending yani azalan sralama yaplabilir.
-- Default'u yani yazlmadnda varsaylan ascending (asc)'dir.
select * from Yonetmen order by adi -- artan sralama
select * from Yonetmen order by adi desc -- azalan sralama

select * from Yonetmen order by adi, soyadi 
-- nce adi stununa gre artan sralama yapar, sonra adi stununa gre sraladklarn soyadi stununa gre artan sralar.

select * from Yonetmen order by adi, soyadi desc
-- nce adi stununa gre artan sralama yapar, sonra adi stununa gre sraladklarn soyadi stununa gre azalan sralar.

-- Bir tablodaki kayt (satr) saysn getirmek iin SQL'in count fonksiyonu kullanlr.
select COUNT(*) from Film
select COUNT(adi) as toplamfilm from Film -- count(*) yerine count(stun ad) da kullanlabilir.
select COUNT(dogumtarihi) from Yonetmen -- count(stun ad): NULL olanlar saymaz.

-- Bir tablodaki saysal veri tipindeki bir stunun maksimum deeri max fonksiyonu ile getirilebilir.
select MAX(gisesi) as [En Cok Gise] from Film -- MAX(stun ad): o stundaki verilerden en byk deeri ver.

-- Bir tablodaki saysal veri tipindeki bir stunun minimum deeri min fonksiyonu ile getirilebilir.
select MIN(gisesi) as [En Az Gise] from Film -- MIN(stun ad): o stundaki verilerden en kk deeri ver.

-- Bir tablodaki saysal veri tipindeki bir stunun verilerinin toplam sum fonksiyonu ile getirilebilir.
select SUM(gisesi) as [Toplam Gise] from Film -- SUM(stun ad): o stundaki verilerin toplamn ver.

-- Bir tablodaki saysal veri tipindeki bir stunun verilerinin ortalamas avg fonksiyonu ile getirilebilir.
select AVG(gisesi) as [Ortalama Gise] from Film -- AVG(stun ad): o stundaki verilerin ortalama deerini ver.

-- Bir tablodaki veriler top ile sralamaya gre batan ka kayt ekilecei belirtilerek getirilebilir.
select top 3 * from Yonetmen -- TOP say stun ad: ilk  kayd getirir.

select top 3 * from Yonetmen order by Id desc -- order by desc'den dolay son  kayd getirir.

select top 1 * from Film order by Id -- film tablosundaki ilk kayd getirir.
select top 1 * from Film order by Id desc -- film tablosundaki son kayd getirir.

-- Eer baka bir veritaban zerinden allyorsa, rnein master, Filmler veritabanndaki Film tablosuna
-- veritaban.dbo.tablo eklinde ulalabilir, dbo tablonun emasdr (schema).
use master
select * from Filmler.dbo.Film

-- WHERE: Sorgu iin koul (art) veya koullar (artlar) belirtmek iin kullanlr. Belirtilen koul veya koullara uyan satrlar etkilenir.
-- Update, delete ve select sorgularnda kullanlr. Birden ok koul iin and (ve) ile or (veya) operatrleri kullanlabilir.
-- Bir koulun deilini almak iin de not operatr kullanlr.
-- Where koulundaki stunlar ile =, !=, >, <, >= ve <= operatrleri kullanlabilir.

use Filmler
select * from Film where Id = 5 -- id'si 5 olan filmi getir.
select * from Film where Id != 5 -- id'si 5 olmayan filmleri getir.
select * from Film where not Id = 5 -- id'si 5 olmayan filmleri getir.
select * from Film where Id < 4 order by Id desc -- id'si 4'ten kk olan filmleri id'ye gre azalan ekilde getir.
select * from Film where Id > 4 -- id'si 4'ten byk olan filmleri id'ye gre artan ekilde getir.

-- id'ye gre artan sralama iin order by id yazmaya gerek yoktur 
-- nk id primary key ve index olduundan otomatikman id'ye gre artan sral gelir.

select * from Yonetmen where Id >= 2 and Id <= 4 -- id'si 2 ile 2'den byk ve 4 ile 4'den kk ynetmenleri getir.

-- id'si 2'den kk veya 4'ten byk ynetmenleri getir.
select * from Yonetmen where Id < 2 or Id > 4 -- 1. sorgu
select * from Yonetmen where not (Id >= 2 and Id <= 4) -- 2. sorgu
-- stteki iki sorgu ayn sonucu verir nk 1. sorgu 2. sorgunun deil operatr parantez ierisindeki koullara datlm halidir.

-- WHERE ile birden ok koul kullanm:
-- Aadaki sorgularda parantez iinde Koul 1 ve Koul 2, parantez dnda da and'den sonra aranan veriler yazlmtr.

select Id from Yonetmen where (Id >= 2 and Id <= 4)

select Id from Yonetmen where (Id >= 2 and Id <= 4) and Id = 2 -- *
select Id from Yonetmen where (Id >= 2 and Id <= 4) and Id = 3 -- *
select Id from Yonetmen where (Id >= 2 and Id <= 4) and Id = 4 -- *

select Id from Yonetmen where (Id >= 2 and Id <= 4) and Id = 5 -- **

select Id from Yonetmen where (Id >= 2 and Id <= 4) and Id = 1 -- ***

select Id from Yonetmen where (Id > 4 and Id < 2) and Id = 3 -- ****

/*
Koul 1 		and			Koul 2				Sonu Koulu		Yonetmen Tablosunda Aranan Veriler (id)		Yonetmen Tablosundan Dnen Sonu Verileri (id)
id >= 2						id <= 4
1 (true)					1 (true)			1 (true)			2, 3, 4	*									2, 3, 4
1 (true)					0 (false)			0 (false)			5 **										Veri dnmez
0 (false)					1 (true)			0 (false)			1 ***										Veri dnmez
id > 4						id < 2
0 (false)					0 (false)			0 (false)			3 ****										Veri dnmez
*/

select Id from Yonetmen where (Id >= 2 or Id <= 4)

select Id from Yonetmen where (Id >= 2 or Id <= 4) and Id = 2 -- *
select Id from Yonetmen where (Id >= 2 or Id <= 4) and Id = 3 -- *
select Id from Yonetmen where (Id >= 2 or Id <= 4) and Id = 4 -- *

select Id from Yonetmen where (Id >= 2 or Id <= 4) and Id = 5 -- **

select Id from Yonetmen where (Id >= 2 or Id <= 4) and Id = 1 -- ***

select Id from Yonetmen where (Id > 4 or Id < 2) and Id = 3 -- ****

/*
Koul 1 		or			Koul 2				Sonu Koulu		Yonetmen Tablosunda Aranan Veriler (id)		Yonetmen Tablosundan Dnen Sonu Verileri (id)
id >= 2						id <= 4
1 (true)					1 (true)			1 (true)			2, 3, 4	*									2, 3, 4
1 (true)					0 (false)			1 (true)			5 **										5
0 (false)					1 (true)			1 (true)			1 ***										1
id > 4						id < 2
0 (false)					0 (false)			0 (false)			3 ****										Veri dnmez
*/

-- SELECT sorgu rnekleri:
select * from Yonetmen where adi = 'James' and soyadi = 'Cameron' and dogumtarihi = '1954-08-16'
-- ad James ve soyad Cameron ve doum tarihi 06.08.1954 olan ynetmenleri getir.

-- Eer aadaki rneklerde olduu gibi birden ok and ve or operatr kullanldnda
-- mutlaka ncelikli koul veya koullar iin parantez kullanlmaldr.
select * from Yonetmen where (adi = 'James' and soyadi = 'Cameron') or adi = 'Ridley'
-- ad James ve soyad Cameron olan veya ad Ridley olan ynetmenleri getir.

select * from Yonetmen where (adi = 'James' and soyadi = 'Cameron') or (adi = 'Ridley' and soyadi = 'Scott')
-- ad James ve soyad Cameron olan veya ad Ridley ve soyad Scott olan ynetmenleri getir.

select * from Yonetmen where ((adi = 'James' and soyadi = 'Cameron') or (adi = 'Ridley' and soyadi = 'Scott')) and dogumtarihi > '1950-01-01'
-- ad James ve soyad Cameron olan veya ad Ridley ve soyad Scott olan ve doum tarihi 01.01.1950'den byk olan ynetmenleri getir.

select * from Tur where Id = 1 or Id = 3 or Id = 5
select * from Tur where Id in (1, 3, 5)
-- in (deerler): kme ierisinden seim yapar, deerleri parantez iindeki parametreler olanlar getir.
-- id'si 1 veya 3 veya 5 olan trleri getir.
-- id'si 1, 3, 5 kmesi ierisinde olan trleri getir.

select * from Tur where Id not in (1, 3, 5)
-- not in (deerler): kme dndan seim yapar, deerleri parantez dndaki parametreler olanlar getir.
-- id'si 1 ve 3 ve 5 olmayan trleri getir.
-- id'si 1, 3, 5 kmesi dnda olan trleri getir.

select * from Tur where Id between 2 and 4
-- id'si 2 (dahil) ve 4 (dahil) arasndaki trleri getir.

select * from Film where yapimyili is NULL
-- yapm yl null olan filmleri getir. where koulunda yapimyili = null yazlmaz.

select * from Film where yapimyili is not null
-- yapm yl null olmayan filmleri getir. where koulunda yapimyili != null yazlmaz.

select * from Film where adi = 'avatar'
-- ad avatar olan filmleri getir. 
-- Veritaban collation' TURKISH_CI_AS 
-- yani TURKISH: Trke, CI: case insensitive, byk kk harf duyarsz ve AS: accent sensitive, aksan duyarl (bizim iin nemsiz)
-- olduundan Avatar veya avatar koulu ayn sonucu dner.

select * from Film where adi like 'avatar'
-- ierisinde tamamen avatar geen filmleri getir. adi = 'avatar' ile ayn sonucu dner yani like = operatr gibi davranr.

select * from Film where adi like 'a%'
-- ad a ile balayan sonu ne olursa olsun filmleri getir. % yerine herhangi bir veya daha fazla karakter gelebilir demektir.

select * from Film where adi like '%ata%'
-- iinde ata geen filmleri getir, ba ve sonu nemli deil. ata banda veya sonunda gese de veri dner.

select * from Film where adi like '%ar'
-- sonu ar ile biten filmleri getir.

select * from Film where adi not like '%ar'
-- sonu ar ile bitmeyen filmleri getir.

select distinct yapimyili from Film where yapimyili is not null order by yapimyili desc
-- null olmayan yapm yllarn yapm ylna gre azalan srada oklayan satrlar teke drerek getir.

select 'al' + ' ' + 'Alsa' AdSoyad
-- al Alsa AdSoyad stununu dner.
-- select her zaman bir tablo ile kullanlmaz, istenilen veriler yazlp ihtiyaca gre zerinde ilemler yaplarak ekilebilir.
-- Burada olduu gibi from ile herhangi bir tablo kullanlmadan da select ile istenilen veri dnlebilir.

select 1 + 2 + 3 as Toplam
-- 6 Toplam stununu dner.

select adi, soyadi, 'Ynetmen' [Tablo Ad] from yonetmen 
-- adi ve soyadi ile birlikte 'Ynetmen' metinsel verisini de tablo ad olarak getir.
-- yonetmen: SQL sorgularnda tablo adlar ile stun adlar byk kk harf duyarsz ekilde yazlabilir.
-- Ancak i harfine dikkat etmek gerekir. rnein eer stun ad Id tanmlandysa id ile select sorgusu yazmak hata verir.